%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Jesper Ellerbek Nielsen
%   Script for exercise 2 - Diffusion Wave Model
%   
%   Hit F5 and see what happens
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear; close all; clc;

% Initialization

dt=0.5;             % Timestep i seconds
Tmax=9000;          % Modeled time in seconds

dx=20;              % Space step, Length of the boxes in the model i meters
Length=10000;       % Length of the channel in meters
Width=3;            % Width of the channel in meters
I0=0.005;           % Bottum slope of the channel

zlower=-0.4;        % Bottum elevation of the channel at the lower boundary

M=30;               % Manning number m^(1/3)/s

h0=0.2237;          % Initial condition, water depth in meters
Q0=0.5;             % Initial condition, water flow in m^3/s

Qupper=0.5;         % Upper boundary, flow boundary in m^3/s
hlower=0.2237;      % Lower boundary, water depth boundary i m

CSOlocation=1500;   % Distance from the upper boundary to the CSO in meters
QcsoMax=0.15;        % The maximum CSO flow m^3/sec
CSOduration=250;    % The duration of the CSO in seconds
CSOstartTime=10;    % The time for the start of the CSO in seconds

FrameDt=60;         % Model time between frames. The model is quite unstable
                    % therefore the model time step needs to be small.
                    % However, it is not necessary to include all model
                    % time steps in your animation.

% Definds the distance from the lower boundary to the center of the boxes
x=(dx/2:dx:Length+dx/2);

% Calculates the bottum elevation of center of the boxes
z=(zlower+I0*Length)-x*I0;

% Set the initial conditions of the water depth
h=ones(1,Length/dx)*h0;
h(Length/dx+1)=hlower;

% Set the initial conditions of the water flow
Q=ones(1,Length/dx+1)*Q0;

% Calculated the CSObox
CSObox=round(CSOlocation/dx);

% Constructing the CSO time serie. The CSO time serie is constructed based
% on a manipulated gaussian disdribution. However measured CSO or MOUSE model results
% could also have been used.
CSO=normpdf(linspace(1,100,round(CSOduration/dt)),50,15);
CSO=CSO/max(CSO).*QcsoMax;
CSOts=zeros(1,Tmax/dt);
CSOts(1,round(CSOstartTime/dt):round(CSOstartTime/dt)+size(CSO,2)-1)=CSO;

% Set the figure and plot
maxh=[-1,-1]; % Used to monitor the wave top 
Fig=figure('position',[300 500 1000 400]);
DepthAx=axes;
ModelPlot=plot(DepthAx,x,h,'b',maxh(1,1),maxh(1,2),'rx');
axis([0 Length 0 0.7]);
xlabel('Distance [m]');
ylabel('Water Depth, h [m]');

% The Diffusion Wave Model
PlotFrame=round(FrameDt/dt);
for t=1:Tmax/dt
    Q(1)=Qupper;
    h(Length/dx+1)=hlower;
    % The contunity equation
    for i=1:Length/dx
        if i==CSObox
            Qs=CSOts(t);
        else
        Qs=0;
        end
    h(i)=h(i)+(Q(i)-Q(i+1)+Qs*dx)*dt/(Width*dx);
    if h(i)<0
        error('h is negative use smaller dt or larger dx')
    end
    end
    % the impulse equation
    for i=2:Length/dx+1
    A(i)=Width*(h(i-1)+h(i))/2;
    P(i)=Width+(h(i-1)+h(i))/2;
    R(i)=A(i)/P(i);
   
    Slope(i)=((h(i-1)+z(i-1))-(h(i)+z(i)))/dx;
   
    if Slope(i)<0
       posSlope=-1*Slope(i);
       v(i)=(-1)*M*R(i)^(2/3)*(posSlope)^(1/2);
       Q(i)=A(i)*v(i);
    else
       v(i)=M*R(i)^(2/3)*Slope(i)^(1/2);
       Q(i)=A(i)*v(i);
    end  
    end
    % Updating the plot and track the wave top
    if PlotFrame==round(FrameDt/dt)
        PlotFrame=0;
    if max(h)>h0*1.05
        maxh(size(maxh,1)+1,1)=x(h==max(h)); % Finds the location of the wave top
        maxh(size(maxh,1),2)=max(h); % Finds the wave top height
    set(ModelPlot(2,1),'Xdata',maxh(:,1),'Ydata',maxh(:,2)); % Update the wate top tracking
    end 
    set(ModelPlot(1,1),'Ydata',h); % Updates the the water depths
    drawnow;
    title(['Time: ',num2str(round(t/60)),' min']); % Updates the titel
    pause(0.05) % Wait a moment to show the figure
    end
    PlotFrame=PlotFrame+1;
end